local assets =
{
	Asset("ANIM", "anim/unit_center.zip"),
	Asset("ANIM", "anim/bmachineshellex.zip"),
    Asset("ATLAS", "images/inventoryimages/bmachineshell.xml"),
	Asset("ATLAS", "images/inventoryimages/bmachineshellex.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("unit_center")
    inst.AnimState:SetBuild("unit_center")
    inst.AnimState:PlayAnimation("box")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "bmachineshell"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/bmachineshell.xml"
    inst:AddComponent("selfstacker")
    MakeHauntableLaunchAndSmash(inst)

    return inst
end
local function exfn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("bmachineshellex")
    inst.AnimState:SetBuild("bmachineshellex")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "bmachineshellex"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/bmachineshellex.xml"
    inst:AddComponent("selfstacker")
    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("bmachineshell", fn, assets),
Prefab("bmachineshellex", exfn, assets)